 ; Nxlay - sequentially freeze all layers but one.  Can be interrupted and
 ; restarted.  Always freezes all layers but the one after the current one,
 ; unless the current one is 0 and the program hasn't been run yet in this
 ; drawing, in which case layer 0 is shown first.
 ; Copyright 1995 by Rocket Software
 ; Alligator hide - nature's answer to corduroy.

 ; Dog - error handler.
 (DEFUN DOG (shk /)
  (setq *error* esav)
  (command "layer" "thaw" "*" "")
 (princ))
 ; Dog end.

 ; Lac - find the layer after the current one.  If there is none then assumes
 ; the current layer is the last one and the next one is the first: 0.
 (DEFUN LAC (/ clay reww notyet layy)
  (setq clay (getvar "clayer"))
  (setq reww T)
  (setq notyet T)
  (while (and (setq layy (cdr (assoc 2 (tblnext "layer" reww))))
               notyet)
         (setq reww ())
         (if (= clay layy) (setq notyet ())))
  (if layy layy "0"))
 ; Lac end.

 ; NxLay - the centre of the universe.
 (DEFUN C:NXLAY (/ gnul)
  (setq esav *error*)                    ; save the previous error handler
  (setq *error* dog)                     ; and install a new one
  (if (and (= (getvar "clayer") "0")
           (null zerofl))
      (command "layer" "thaw" "0" "freeze" "*" "")
      (progn
           (setq gnul (lac))
           (command "layer" "thaw" gnul "set" gnul "freeze" "*" "")))
  (setq zerofl T)
  (setq *error* esav)                    ; restore error handler
 (princ))